use "C:\Users\nsarin\Dropbox\Z__Natamir\Natasha_Research\Banks\Control Banks\Control_Data\Stack\fullvars_stack.dta", clear

gen imp_minus_market = impvol - market_imp 
gen vol_minus_market = vol_thirty - market_vol 
gen imp_div_market = impvol/market_imp
gen vol_div_market=vol_thirty/market_vol 
gen crisis = . 
replace crisis = 0 if year >= 2002 & year <= 2007 
replace crisis = 1 if year >= 2010
**replace crisis = 2 if year == 2015  
drop if crisis == . 
gen big6 = 0 
replace big6 = 1 if name == "baml" | name == "ms" | name == "jpm" | name == "gs" | name == "wf" | name == "citi"

by crisis name, sort: egen beta_crisis = mean(beta)
by crisis name, sort: egen cds_crisis = mean(cds)
by crisis name, sort: egen vol_crisis = mean(vol) 
by crisis name, sort: egen impvol_crisis = mean(impvol)
by crisis name, sort: egen ptb_crisis = mean(ptb)
by crisis name, sort: egen imp_minus_market_crisis = mean(imp_minus_market)
by crisis name, sort: egen vol_minus_market_crisis = mean(vol_minus_market)
by crisis name, sort: egen vol_div_market_crisis = mean(vol_div_market)
by crisis name, sort: egen imp_div_market_crisis = mean(imp_div_market)
by crisis name, sort: egen markcap_crisis = mean(markcap)

keep if big6 == 1 

by crisis, sort: egen beta_crisis_weight = wtmean(beta), weight(markcap)
by crisis, sort: egen cds_crisis_weight = wtmean(cds), weight(markcap)
by crisis, sort: egen vol_crisis_mean = wtmean(vol), weight(markcap)
by crisis, sort: egen impvol_crisis_mean = wtmean(impvol), weight(markcap)
by crisis, sort: egen ptb_crisis_mean = wtmean(ptb), weight(markcap)
by crisis, sort: egen imp_minus_market_mean = wtmean(imp_minus_market), weight(markcap)
by crisis, sort: egen vol_minus_market_mean = wtmean(vol_minus_market), weight(markcap)
by crisis, sort: egen vol_div_market_mean = wtmean(vol_div_market), weight(markcap)
by crisis, sort: egen imp_div_market_mean = wtmean(imp_div_market), weight(markcap)

capture drop output_indicator 
by crisis, sort: gen output_indicator = _n 
br beta_crisis_weight cds_crisis_weight vol_crisis_mean impvol_crisis_mean ptb_crisis_mean imp_minus_market_mean vol_minus_market_mean vol_div_market_mean imp_div_market_mean if output_indicator == 1 
by year, sort: egen beta_crisis_year = wtmean(beta), weight(markcap)
by year, sort: egen cds_crisis_year = wtmean(cds), weight(markcap)
by year, sort: egen vol_crisis_year = wtmean(vol), weight(markcap)
by year, sort: egen impvol_crisis_year = wtmean(impvol), weight(markcap)
by year, sort: egen ptb_crisis_year = wtmean(ptb), weight(markcap)
by year, sort: egen imp_minus_market_year = wtmean(imp_minus_market), weight(markcap)
by year, sort: egen vol_minus_market_year = wtmean(vol_minus_market), weight(markcap)
by year, sort: egen vol_div_market_year = wtmean(vol_div_market), weight(markcap)
by year, sort: egen imp_div_market_year = wtmean(imp_div_market), weight(markcap)

capture drop output_indicator 
by year, sort: gen output_indicator = _n 
br beta_crisis_year cds_crisis_year vol_crisis_year impvol_crisis_year ptb_crisis_year imp_minus_market_year vol_minus_market_year vol_div_market_year imp_div_market_year if output_indicator == 1 & year == 2015 
